import flixel.text.FlxTextBorderStyle;
import flixel.text.FlxTextAlign;
import flixel.ui.FlxBar;
import flixel.text.FlxTextFormatMarkerPair;
import flixel.text.FlxTextFormat;

var rainbow:CustomShader = new CustomShader('rainbow');
var ratingTxt:FlxText;
var ratingTxtTimeout = 0;
var rTmarkerFormat:FlxTextFormat = new FlxTextFormat(0xFFFFFFFF);
var rTmarkerPair:FlxTextFormatMarkerPair = new FlxTextFormatMarkerPair(rTmarkerFormat, "[w]");

// var hit:FlxSound = FlxG.sound.load(Paths.sound("sanic/sanicHit"));
// newRatingsVisible = false;
// thanks yasher - abyss
function onNoteCreation(event) {
	event.cancel();
	var note = event.note;

	if (!event.cancel) {
		switch (event.noteType) {
			default:
				note.frames = Paths.getFrames('game/notes/sanic/arrows');
				switch (event.strumID % 4) {
					case 0:
						note.animation.addByPrefix('scroll', 'purple0');
						note.animation.addByPrefix('hold', 'purple hold piece');
						note.animation.addByPrefix('holdend', 'purple hold end');
					case 1:
						note.animation.addByPrefix('scroll', 'blue0');
						note.animation.addByPrefix('hold', 'blue hold piece');
						note.animation.addByPrefix('holdend', 'blue hold end');
					case 2:
						note.animation.addByPrefix('scroll', 'green0');
						note.animation.addByPrefix('hold', 'green hold piece');
						note.animation.addByPrefix('holdend', 'green hold end');
					case 3:
						note.animation.addByPrefix('scroll', 'red0');
						note.animation.addByPrefix('hold', 'red hold piece');
						note.animation.addByPrefix('holdend', 'red hold end');
				}
				note.scale.set(0.7, 0.7);
				note.updateHitbox();
		}
	}
}

function onPostNoteCreation(event) {
	var splashes = event.note;
	splashes.splash = "sanic-splash";
}

function onStrumCreation(event) {
	event.cancel();
	var strum = event.strum;

	if (!event.cancel) {
		strum.frames = Paths.getFrames('game/notes/sanic/arrows');
		strum.animation.addByPrefix('green', 'arrowUP');
		strum.animation.addByPrefix('blue', 'arrowDOWN');
		strum.animation.addByPrefix('purple', 'arrowLEFT');
		strum.animation.addByPrefix('red', 'arrowRIGHT');
		strum.antialiasing = true;
		strum.scale.set(0.7, 0.7);

		switch (event.strumID % 4) {
			case 0:
				strum.animation.addByPrefix("static", 'arrowLEFT0');
				strum.animation.addByPrefix("pressed", 'left press', 12, false);
				strum.animation.addByPrefix("confirm", 'left confirm', 24, false);
			case 1:
				strum.animation.addByPrefix("static", 'arrowDOWN0');
				strum.animation.addByPrefix("pressed", 'down press', 12, false);
				strum.animation.addByPrefix("confirm", 'down confirm', 24, false);
			case 2:
				strum.animation.addByPrefix("static", 'arrowUP0');
				strum.animation.addByPrefix("pressed", 'up press', 12, false);
				strum.animation.addByPrefix("confirm", 'up confirm', 24, false);
			case 3:
				strum.animation.addByPrefix("static", 'arrowRIGHT0');
				strum.animation.addByPrefix("pressed", 'right press', 12, false);
				strum.animation.addByPrefix("confirm", 'right confirm', 24, false);
		}
		strum.updateHitbox();
	}
}

function onCountdown(event) {
	event.soundPath = 'sanic/' + event.soundPath;
	event.spritePath = switch (event.swagCounter) {
		case 0: null;
		case 1: 'game/hud/sanic/ready';
		case 2: 'game/hud/sanic/set';
		case 3: 'game/hud/sanic/go';
	};
}

function postCreate() {
	PlayState.instance.comboGroup.visible = false;
	for (i in [accuracyTxt, missesTxt, scoreTxt])
		i.setFormat(Paths.font("comic.ttf"), 19, null, null, FlxTextBorderStyle.OUTLINE, 0xFF000000);
	healthBarBG.loadGraphic(Paths.image('game/hud/sanic/healthbar'));
	healthBarBG.screenCenter(FlxAxes.X);
	if (downscroll) {
		healthBarBG.y = healthBar.y - 12;
	} else {
		healthBarBG.y = healthBar.y - 15;
	}
	healthBar.scale.set(0.76, 1.13);
	iconP1.antialiasing = false;
	iconP2.antialiasing = false;

	GameOverSubstate.script = 'data/scripts/gameovers/sanic';

	add(ratingTxt = new FlxText(0, 0, 0, " "));
	ratingTxt.cameras = [camHUD];
	ratingTxt.setFormat(Paths.font('comic.ttf'), 32, 0xFFFFFFFF, FlxTextAlign.CENTER, FlxTextBorderStyle.OUTLINE, 0xFF000000);
	ratingTxt.screenCenter(FlxAxes.X);
	ratingTxt.y = healthBarBG.y - 35;
}

var time:Float = 0;

// var rainbowActive = false;

function update(elapsed) {
	if (PlayState.instance.combo > 100) {
		ratingTxt.shader = rainbow;
		rainbow.iTime = time;
		time += elapsed * 3;
	} else
		ratingTxt.shader = null;
}

function onPlayerHit(event:NoteHitEvent) {
	if (!event.note.isSustainNote) {
		var funny:String = "";
		var funnyClr:FlxColor = 0xFFFFFFFF;

		switch (event.rating) {
			case 'sick':
				funny = 'OHHHHH!!!!';
				funnyClr = 0x00FF00;
			// hit.play(true);
			case 'good':
				funny = 'SWAG!!';
				funnyClr = 0xbbff55;
			case 'bad':
				funny = 'Not Cool!';
				funnyClr = 0xffd15c;
			case 'shit':
				funny = 'TERRIBLE!!!!';
				funnyClr = 0xD82800;
		}
		ratingTxt.text = funny + " " + (PlayState.instance.combo) + (PlayState.instance.combo < 100 ? ' Combo' : ' WOMBO COMBO!!!');
		ratingTxt.applyMarkup(ratingTxt.text, [rTmarkerPair]);
		ratingTxt.color = funnyClr;
		ratingTxt.screenCenter(FlxAxes.X);
		ratingTxt.alpha = 1;
	}

	ratingTxtTimeout = 18;
}

function onPlayerMiss(event:NoteHitEvent) {
	ratingTxt.text = "FUCK!!!!!!!!!!!!!";
	ratingTxt.color = 0xFF0000;
	ratingTxt.screenCenter(FlxAxes.X);

	ratingTxtTimeout = 18;
	ratingTxt.alpha = 1;
}

function stepHit(step) {
	if (ratingTxtTimeout > 0)
		ratingTxtTimeout -= 1;

	if (ratingTxtTimeout == 0) {
		ratingTxt.alpha = 0.001;
	} // else ratingTxt.alpha = 1;
}

